/*
 ************************************************************************************************
 *                                                                                              *
 *  OSA cooperative RTOS for Microchip PIC-controllers: PIC10/12/16/18/24/dsPIC                 *
 *                                                                                              *
 *  URL:        http://wiki.pic24.ru/doku.php/en/osa/ref/intro                                  *
 *              http://picosa.narod.ru                                                          *
 *                                                                                              *
 *----------------------------------------------------------------------------------------------*
 *                                                                                              *
 *  File:       osa_timer.h                                                                     *
 *                                                                                              *
 *  Compilers:  HT-PICC STD                                                                     *
 *              HT-PICC18 STD                                                                   *
 *              Microchip C18                                                                   *
 *              Microchip C30                                                                   *
 *                                                                                              *
 *  Programmer: Timofeev Victor                                                                 *
 *              osa@pic24.ru, testerplus@mail.ru                                                *
 *                                                                                              *
 *  Definition: Services for work with system timer                                             *
 *                                                                                              *
 *  History:    21.01.2009                                                                      *
 *                                                                                              *
 ************************************************************************************************
 */



/************************************************************************************************
 *                                                                                              *
 *                          S Y S T E M   T I M E R   W O R K                                   *
 *                                                                                              *
 ************************************************************************************************/

#ifndef _OS_TIMER_H_
#define _OS_TIMER_H_




//------------------------------------------------------------------------------
#ifndef OS_ENABLE_DTIMERS
//------------------------------------------------------------------------------

    #define __OS_DTimersWork()

//------------------------------------------------------------------------------
#else
//------------------------------------------------------------------------------

    #define _OS_SetIndfTimerTimeout         {((NEAR OST_DTIMER_FLAGS*)(&_indf))->bTimeout = 1;}
    #define _OS_SetIndfTimerActive          {((NEAR OST_DTIMER_FLAGS*)(&_indf))->bActive = 1;}
    #define _OS_SetIndfTimerNextEnable      {((NEAR OST_DTIMER_FLAGS*)(&_indf))->bNextEnable = 1;}

    #define _OS_ClearIndfTimerTimeout       {((NEAR OST_DTIMER_FLAGS*)(&_indf))->bTimeout = 0;}
    #define _OS_ClearIndfTimerActive        {((NEAR OST_DTIMER_FLAGS*)(&_indf))->bActive = 0;}
    #define _OS_ClearIndfTimerNextEnable    {((NEAR OST_DTIMER_FLAGS*)(&_indf))->bNextEnable = 0;}

    #define _OS_CheckIndfTimerTimeout       (((NEAR OST_DTIMER_FLAGS*)(&_indf))->bTimeout)
    #define _OS_CheckIndfTimerActive        (((NEAR OST_DTIMER_FLAGS*)(&_indf))->bActive)
    #define _OS_CheckIndfTimerRun           (((NEAR OST_DTIMER_FLAGS*)(&_indf))->bRun)
    #define _OS_CheckIndfTimerNextEnable    (((NEAR OST_DTIMER_FLAGS*)(&_indf))->bNextEnable)
    #define _OS_CheckPostincTimerNextEnable (((NEAR OST_DTIMER_FLAGS*)(&_postinc))->bNextEnable)


//------------------------------------------------------------------------------
#endif  // OS_ENABLE_DTIMER
//------------------------------------------------------------------------------





/************************************************************************/
/* Old style static timers                                              */
/************************************************************************/

//------------------------------------------------------------------------------
#ifndef __OS_Timer8Work
//------------------------------------------------------------------------------

#define __OS_Timer8Work(TIMER_ID,L)                                                             \
    {                                                                                           \
        if ((OS_Timeouts[(TIMER_ID)>>_OST_INT_SHIFT]&(1<<((TIMER_ID)&_OST_INT_MASK)))) {        \
            if (!++OS_Timers8[TIMER_ID])                                                        \
                OS_Timeouts[(TIMER_ID)>>_OST_INT_SHIFT] &= ~(1<<((TIMER_ID)&_OST_INT_MASK));    \
        }                                                                                       \
    }

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
#ifndef __OS_Timer16Work
//------------------------------------------------------------------------------

#define __OS_Timer16Work(TIMER_ID,L)                                                                                        \
    {                                                                                                                       \
        if ((OS_Timeouts[(TIMER_ID+_OS_TIMER16_POS)>>_OST_INT_SHIFT]&(1<<((TIMER_ID+_OS_TIMER16_POS)&_OST_INT_MASK)))) {    \
            if (!++OS_Timers16[TIMER_ID])                                                                                   \
                OS_Timeouts[(TIMER_ID+_OS_TIMER16_POS)>>_OST_INT_SHIFT] &= ~(1<<((TIMER_ID+_OS_TIMER16_POS)&_OST_INT_MASK));\
        }                                                                                                                   \
    }

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
#ifndef __OS_Timer24Work
//------------------------------------------------------------------------------

#define __OS_Timer24Work(TIMER_ID,L)                                                                                        \
    {                                                                                                                       \
        if ((OS_Timeouts[(TIMER_ID+_OS_TIMER24_POS)>>_OST_INT_SHIFT]&(1<<((TIMER_ID+_OS_TIMER24_POS)&_OST_INT_MASK)))) {    \
            if (!++OS_Timers24[TIMER_ID])                                                                                   \
                OS_Timeouts[(TIMER_ID+_OS_TIMER24_POS)>>_OST_INT_SHIFT] &= ~(1<<((TIMER_ID+_OS_TIMER24_POS)&_OST_INT_MASK));\
        }                                                                                                                   \
    }

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
#ifndef __OS_Timer32Work
//------------------------------------------------------------------------------

#define __OS_Timer32Work(TIMER_ID,L)                                                                                        \
    {                                                                                                                       \
        if ((OS_Timeouts[(TIMER_ID+_OS_TIMER32_POS)>>_OST_INT_SHIFT]&(1<<((TIMER_ID+_OS_TIMER32_POS)&_OST_INT_MASK)))) {    \
            if (!++OS_Timers32[TIMER_ID])                                                                                   \
                OS_Timeouts[(TIMER_ID+_OS_TIMER32_POS)>>_OST_INT_SHIFT] &= ~(1<<((TIMER_ID+_OS_TIMER32_POS)&_OST_INT_MASK));\
        }                                                                                                                   \
    }

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------






/************************************************************************/
/* Task timers                                                          */
/************************************************************************/

//------------------------------------------------------------------------------
#ifndef __OS_TaskTimerWork
//------------------------------------------------------------------------------

#define __OS_TaskTimerWork(TASK_ID, L)                                              \
    if (OS_TaskVars[TASK_ID].State.bDelay)                                          \
    {                                                                               \
        if(!++OS_TaskVars[TASK_ID].Timer) OS_TaskVars[TASK_ID].State.bDelay = 0;    \
    }                                                                               \

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------




/************************************************************************/
/* New style static timers                                              */
/************************************************************************/

//------------------------------------------------------------------------------
#ifndef __OS_STimerWork
//------------------------------------------------------------------------------

#define __OS_STimerWork(STIMER_ID, L)                                               \
    if (OS_STimers[STIMER_ID] & OS_STIMER_RUN)                                      \
    {                                                                               \
        OS_STimers[STIMER_ID]++;                                                    \
    }                                                                               \

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------









/************************************************************************************************
 *                                                                                              *
 *                         C O M M O N   T I M E R ' S   M A C R O S                             *
 *                                                                                               *
 ************************************************************************************************/

#if OS_TIMERS8 > 0
#define __OS_Timer8Work0(L)    __OS_Timer8Work(0,L)
#else
#define __OS_Timer8Work0(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 1
#define __OS_Timer8Work1(L)    __OS_Timer8Work(1,L)
#else
#define __OS_Timer8Work1(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 2
#define __OS_Timer8Work2(L)    __OS_Timer8Work(2,L)
#else
#define __OS_Timer8Work2(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 3
#define __OS_Timer8Work3(L)    __OS_Timer8Work(3,L)
#else
#define __OS_Timer8Work3(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 4
#define __OS_Timer8Work4(L)    __OS_Timer8Work(4,L)
#else
#define __OS_Timer8Work4(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 5
#define __OS_Timer8Work5(L)    __OS_Timer8Work(5,L)
#else
#define __OS_Timer8Work5(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 6
#define __OS_Timer8Work6(L)    __OS_Timer8Work(6,L)
#else
#define __OS_Timer8Work6(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 7
#define __OS_Timer8Work7(L)    __OS_Timer8Work(7,L)
#else
#define __OS_Timer8Work7(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 8
#define __OS_Timer8Work8(L)    __OS_Timer8Work(8,L)
#else
#define __OS_Timer8Work8(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 9
#define __OS_Timer8Work9(L)    __OS_Timer8Work(9,L)
#else
#define __OS_Timer8Work9(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 10
#define __OS_Timer8Work10(L)    __OS_Timer8Work(10,L)
#else
#define __OS_Timer8Work10(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 11
#define __OS_Timer8Work11(L)    __OS_Timer8Work(11,L)
#else
#define __OS_Timer8Work11(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 12
#define __OS_Timer8Work12(L)    __OS_Timer8Work(12,L)
#else
#define __OS_Timer8Work12(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 13
#define __OS_Timer8Work13(L)    __OS_Timer8Work(13,L)
#else
#define __OS_Timer8Work13(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 14
#define __OS_Timer8Work14(L)    __OS_Timer8Work(14,L)
#else
#define __OS_Timer8Work14(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 15
#define __OS_Timer8Work15(L)    __OS_Timer8Work(15,L)
#else
#define __OS_Timer8Work15(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 16
#define __OS_Timer8Work16(L)    __OS_Timer8Work(16,L)
#else
#define __OS_Timer8Work16(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 17
#define __OS_Timer8Work17(L)    __OS_Timer8Work(17,L)
#else
#define __OS_Timer8Work17(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 18
#define __OS_Timer8Work18(L)    __OS_Timer8Work(18,L)
#else
#define __OS_Timer8Work18(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 19
#define __OS_Timer8Work19(L)    __OS_Timer8Work(19,L)
#else
#define __OS_Timer8Work19(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 20
#define __OS_Timer8Work20(L)    __OS_Timer8Work(20,L)
#else
#define __OS_Timer8Work20(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 21
#define __OS_Timer8Work21(L)    __OS_Timer8Work(21,L)
#else
#define __OS_Timer8Work21(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 22
#define __OS_Timer8Work22(L)    __OS_Timer8Work(22,L)
#else
#define __OS_Timer8Work22(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 23
#define __OS_Timer8Work23(L)    __OS_Timer8Work(23,L)
#else
#define __OS_Timer8Work23(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 24
#define __OS_Timer8Work24(L)    __OS_Timer8Work(24,L)
#else
#define __OS_Timer8Work24(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 25
#define __OS_Timer8Work25(L)    __OS_Timer8Work(25,L)
#else
#define __OS_Timer8Work25(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 26
#define __OS_Timer8Work26(L)    __OS_Timer8Work(26,L)
#else
#define __OS_Timer8Work26(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 27
#define __OS_Timer8Work27(L)    __OS_Timer8Work(27,L)
#else
#define __OS_Timer8Work27(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 28
#define __OS_Timer8Work28(L)    __OS_Timer8Work(28,L)
#else
#define __OS_Timer8Work28(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 29
#define __OS_Timer8Work29(L)    __OS_Timer8Work(29,L)
#else
#define __OS_Timer8Work29(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 30
#define __OS_Timer8Work30(L)    __OS_Timer8Work(30,L)
#else
#define __OS_Timer8Work30(L)
#endif
//..............................................................................
#if OS_TIMERS8 > 31
#define __OS_Timer8Work31(L)    __OS_Timer8Work(31,L)
#else
#define __OS_Timer8Work31(L)
#endif
//..............................................................................


//______________________________________________________________________________
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//..............................................................................
#if OS_TIMERS16 > 0
#define __OS_Timer16Work0(L)    __OS_Timer16Work(0,L)
#else
#define __OS_Timer16Work0(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 1
#define __OS_Timer16Work1(L)    __OS_Timer16Work(1,L)
#else
#define __OS_Timer16Work1(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 2
#define __OS_Timer16Work2(L)    __OS_Timer16Work(2,L)
#else
#define __OS_Timer16Work2(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 3
#define __OS_Timer16Work3(L)    __OS_Timer16Work(3,L)
#else
#define __OS_Timer16Work3(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 4
#define __OS_Timer16Work4(L)    __OS_Timer16Work(4,L)
#else
#define __OS_Timer16Work4(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 5
#define __OS_Timer16Work5(L)    __OS_Timer16Work(5,L)
#else
#define __OS_Timer16Work5(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 6
#define __OS_Timer16Work6(L)    __OS_Timer16Work(6,L)
#else
#define __OS_Timer16Work6(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 7
#define __OS_Timer16Work7(L)    __OS_Timer16Work(7,L)
#else
#define __OS_Timer16Work7(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 8
#define __OS_Timer16Work8(L)    __OS_Timer16Work(8,L)
#else
#define __OS_Timer16Work8(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 9
#define __OS_Timer16Work9(L)    __OS_Timer16Work(9,L)
#else
#define __OS_Timer16Work9(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 10
#define __OS_Timer16Work10(L)    __OS_Timer16Work(10,L)
#else
#define __OS_Timer16Work10(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 11
#define __OS_Timer16Work11(L)    __OS_Timer16Work(11,L)
#else
#define __OS_Timer16Work11(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 12
#define __OS_Timer16Work12(L)    __OS_Timer16Work(12,L)
#else
#define __OS_Timer16Work12(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 13
#define __OS_Timer16Work13(L)    __OS_Timer16Work(13,L)
#else
#define __OS_Timer16Work13(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 14
#define __OS_Timer16Work14(L)    __OS_Timer16Work(14,L)
#else
#define __OS_Timer16Work14(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 15
#define __OS_Timer16Work15(L)    __OS_Timer16Work(15,L)
#else
#define __OS_Timer16Work15(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 16
#define __OS_Timer16Work16(L)    __OS_Timer16Work(16,L)
#else
#define __OS_Timer16Work16(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 17
#define __OS_Timer16Work17(L)    __OS_Timer16Work(17,L)
#else
#define __OS_Timer16Work17(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 18
#define __OS_Timer16Work18(L)    __OS_Timer16Work(18,L)
#else
#define __OS_Timer16Work18(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 19
#define __OS_Timer16Work19(L)    __OS_Timer16Work(19,L)
#else
#define __OS_Timer16Work19(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 20
#define __OS_Timer16Work20(L)    __OS_Timer16Work(20,L)
#else
#define __OS_Timer16Work20(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 21
#define __OS_Timer16Work21(L)    __OS_Timer16Work(21,L)
#else
#define __OS_Timer16Work21(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 22
#define __OS_Timer16Work22(L)    __OS_Timer16Work(22,L)
#else
#define __OS_Timer16Work22(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 23
#define __OS_Timer16Work23(L)    __OS_Timer16Work(23,L)
#else
#define __OS_Timer16Work23(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 24
#define __OS_Timer16Work24(L)    __OS_Timer16Work(24,L)
#else
#define __OS_Timer16Work24(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 25
#define __OS_Timer16Work25(L)    __OS_Timer16Work(25,L)
#else
#define __OS_Timer16Work25(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 26
#define __OS_Timer16Work26(L)    __OS_Timer16Work(26,L)
#else
#define __OS_Timer16Work26(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 27
#define __OS_Timer16Work27(L)    __OS_Timer16Work(27,L)
#else
#define __OS_Timer16Work27(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 28
#define __OS_Timer16Work28(L)    __OS_Timer16Work(28,L)
#else
#define __OS_Timer16Work28(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 29
#define __OS_Timer16Work29(L)    __OS_Timer16Work(29,L)
#else
#define __OS_Timer16Work29(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 30
#define __OS_Timer16Work30(L)    __OS_Timer16Work(30,L)
#else
#define __OS_Timer16Work30(L)
#endif
//..............................................................................
#if OS_TIMERS16 > 31
#define __OS_Timer16Work31(L)    __OS_Timer16Work(31,L)
#else
#define __OS_Timer16Work31(L)
#endif
//..............................................................................






//______________________________________________________________________________
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
#if OS_TIMERS24 > 0
#define __OS_CheckInc24()   if (!(OS_Ticks & 0xFF))
#else
#define __OS_CheckInc24()
#endif


//..............................................................................
#if OS_TIMERS24 > 0
#define __OS_Timer24Work0(L)    __OS_Timer24Work(0,L)
#else
#define __OS_Timer24Work0(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 1
#define __OS_Timer24Work1(L)    __OS_Timer24Work(1,L)
#else
#define __OS_Timer24Work1(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 2
#define __OS_Timer24Work2(L)    __OS_Timer24Work(2,L)
#else
#define __OS_Timer24Work2(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 3
#define __OS_Timer24Work3(L)    __OS_Timer24Work(3,L)
#else
#define __OS_Timer24Work3(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 4
#define __OS_Timer24Work4(L)    __OS_Timer24Work(4,L)
#else
#define __OS_Timer24Work4(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 5
#define __OS_Timer24Work5(L)    __OS_Timer24Work(5,L)
#else
#define __OS_Timer24Work5(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 6
#define __OS_Timer24Work6(L)    __OS_Timer24Work(6,L)
#else
#define __OS_Timer24Work6(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 7
#define __OS_Timer24Work7(L)    __OS_Timer24Work(7,L)
#else
#define __OS_Timer24Work7(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 8
#define __OS_Timer24Work8(L)    __OS_Timer24Work(8,L)
#else
#define __OS_Timer24Work8(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 9
#define __OS_Timer24Work9(L)    __OS_Timer24Work(9,L)
#else
#define __OS_Timer24Work9(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 10
#define __OS_Timer24Work10(L)    __OS_Timer24Work(10,L)
#else
#define __OS_Timer24Work10(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 11
#define __OS_Timer24Work11(L)    __OS_Timer24Work(11,L)
#else
#define __OS_Timer24Work11(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 12
#define __OS_Timer24Work12(L)    __OS_Timer24Work(12,L)
#else
#define __OS_Timer24Work12(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 13
#define __OS_Timer24Work13(L)    __OS_Timer24Work(13,L)
#else
#define __OS_Timer24Work13(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 14
#define __OS_Timer24Work14(L)    __OS_Timer24Work(14,L)
#else
#define __OS_Timer24Work14(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 15
#define __OS_Timer24Work15(L)    __OS_Timer24Work(15,L)
#else
#define __OS_Timer24Work15(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 16
#define __OS_Timer24Work16(L)    __OS_Timer24Work(16,L)
#else
#define __OS_Timer24Work16(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 17
#define __OS_Timer24Work17(L)    __OS_Timer24Work(17,L)
#else
#define __OS_Timer24Work17(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 18
#define __OS_Timer24Work18(L)    __OS_Timer24Work(18,L)
#else
#define __OS_Timer24Work18(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 19
#define __OS_Timer24Work19(L)    __OS_Timer24Work(19,L)
#else
#define __OS_Timer24Work19(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 20
#define __OS_Timer24Work20(L)    __OS_Timer24Work(20,L)
#else
#define __OS_Timer24Work20(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 21
#define __OS_Timer24Work21(L)    __OS_Timer24Work(21,L)
#else
#define __OS_Timer24Work21(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 22
#define __OS_Timer24Work22(L)    __OS_Timer24Work(22,L)
#else
#define __OS_Timer24Work22(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 23
#define __OS_Timer24Work23(L)    __OS_Timer24Work(23,L)
#else
#define __OS_Timer24Work23(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 24
#define __OS_Timer24Work24(L)    __OS_Timer24Work(24,L)
#else
#define __OS_Timer24Work24(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 25
#define __OS_Timer24Work25(L)    __OS_Timer24Work(25,L)
#else
#define __OS_Timer24Work25(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 26
#define __OS_Timer24Work26(L)    __OS_Timer24Work(26,L)
#else
#define __OS_Timer24Work26(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 27
#define __OS_Timer24Work27(L)    __OS_Timer24Work(27,L)
#else
#define __OS_Timer24Work27(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 28
#define __OS_Timer24Work28(L)    __OS_Timer24Work(28,L)
#else
#define __OS_Timer24Work28(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 29
#define __OS_Timer24Work29(L)    __OS_Timer24Work(29,L)
#else
#define __OS_Timer24Work29(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 30
#define __OS_Timer24Work30(L)    __OS_Timer24Work(30,L)
#else
#define __OS_Timer24Work30(L)
#endif
//..............................................................................
#if OS_TIMERS24 > 31
#define __OS_Timer24Work31(L)    __OS_Timer24Work(31,L)
#else
#define __OS_Timer24Work31(L)
#endif
//..............................................................................













//______________________________________________________________________________
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//..............................................................................
#if OS_TIMERS32 > 0
#define __OS_Timer32Work0(L)    __OS_Timer32Work(0,L)
#else
#define __OS_Timer32Work0(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 1
#define __OS_Timer32Work1(L)    __OS_Timer32Work(1,L)
#else
#define __OS_Timer32Work1(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 2
#define __OS_Timer32Work2(L)    __OS_Timer32Work(2,L)
#else
#define __OS_Timer32Work2(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 3
#define __OS_Timer32Work3(L)    __OS_Timer32Work(3,L)
#else
#define __OS_Timer32Work3(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 4
#define __OS_Timer32Work4(L)    __OS_Timer32Work(4,L)
#else
#define __OS_Timer32Work4(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 5
#define __OS_Timer32Work5(L)    __OS_Timer32Work(5,L)
#else
#define __OS_Timer32Work5(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 6
#define __OS_Timer32Work6(L)    __OS_Timer32Work(6,L)
#else
#define __OS_Timer32Work6(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 7
#define __OS_Timer32Work7(L)    __OS_Timer32Work(7,L)
#else
#define __OS_Timer32Work7(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 8
#define __OS_Timer32Work8(L)    __OS_Timer32Work(8,L)
#else
#define __OS_Timer32Work8(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 9
#define __OS_Timer32Work9(L)    __OS_Timer32Work(9,L)
#else
#define __OS_Timer32Work9(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 10
#define __OS_Timer32Work10(L)    __OS_Timer32Work(10,L)
#else
#define __OS_Timer32Work10(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 11
#define __OS_Timer32Work11(L)    __OS_Timer32Work(11,L)
#else
#define __OS_Timer32Work11(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 12
#define __OS_Timer32Work12(L)    __OS_Timer32Work(12,L)
#else
#define __OS_Timer32Work12(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 13
#define __OS_Timer32Work13(L)    __OS_Timer32Work(13,L)
#else
#define __OS_Timer32Work13(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 14
#define __OS_Timer32Work14(L)    __OS_Timer32Work(14,L)
#else
#define __OS_Timer32Work14(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 15
#define __OS_Timer32Work15(L)    __OS_Timer32Work(15,L)
#else
#define __OS_Timer32Work15(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 16
#define __OS_Timer32Work16(L)    __OS_Timer32Work(16,L)
#else
#define __OS_Timer32Work16(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 17
#define __OS_Timer32Work17(L)    __OS_Timer32Work(17,L)
#else
#define __OS_Timer32Work17(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 18
#define __OS_Timer32Work18(L)    __OS_Timer32Work(18,L)
#else
#define __OS_Timer32Work18(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 19
#define __OS_Timer32Work19(L)    __OS_Timer32Work(19,L)
#else
#define __OS_Timer32Work19(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 20
#define __OS_Timer32Work20(L)    __OS_Timer32Work(20,L)
#else
#define __OS_Timer32Work20(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 21
#define __OS_Timer32Work21(L)    __OS_Timer32Work(21,L)
#else
#define __OS_Timer32Work21(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 22
#define __OS_Timer32Work22(L)    __OS_Timer32Work(22,L)
#else
#define __OS_Timer32Work22(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 23
#define __OS_Timer32Work23(L)    __OS_Timer32Work(23,L)
#else
#define __OS_Timer32Work23(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 24
#define __OS_Timer32Work24(L)    __OS_Timer32Work(24,L)
#else
#define __OS_Timer32Work24(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 25
#define __OS_Timer32Work25(L)    __OS_Timer32Work(25,L)
#else
#define __OS_Timer32Work25(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 26
#define __OS_Timer32Work26(L)    __OS_Timer32Work(26,L)
#else
#define __OS_Timer32Work26(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 27
#define __OS_Timer32Work27(L)    __OS_Timer32Work(27,L)
#else
#define __OS_Timer32Work27(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 28
#define __OS_Timer32Work28(L)    __OS_Timer32Work(28,L)
#else
#define __OS_Timer32Work28(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 29
#define __OS_Timer32Work29(L)    __OS_Timer32Work(29,L)
#else
#define __OS_Timer32Work29(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 30
#define __OS_Timer32Work30(L)    __OS_Timer32Work(30,L)
#else
#define __OS_Timer32Work30(L)
#endif
//..............................................................................
#if OS_TIMERS32 > 31
#define __OS_Timer32Work31(L)    __OS_Timer32Work(31,L)
#else
#define __OS_Timer32Work31(L)
#endif
//..............................................................................







//______________________________________________________________________________
//******************************************************************************
/**/


#if OS_TASKS > 0
#define __OS_TaskTimerWork0(L)    __OS_TaskTimerWork(0,L)
#else
#define __OS_TaskTimerWork0(L)
#endif
//...........................................................
#if OS_TASKS > 1
#define __OS_TaskTimerWork1(L)    __OS_TaskTimerWork(1,L)
#else
#define __OS_TaskTimerWork1(L)
#endif
//...........................................................
#if OS_TASKS > 2
#define __OS_TaskTimerWork2(L)    __OS_TaskTimerWork(2,L)
#else
#define __OS_TaskTimerWork2(L)
#endif
//...........................................................
#if OS_TASKS > 3
#define __OS_TaskTimerWork3(L)    __OS_TaskTimerWork(3,L)
#else
#define __OS_TaskTimerWork3(L)
#endif
//...........................................................
#if OS_TASKS > 4
#define __OS_TaskTimerWork4(L)    __OS_TaskTimerWork(4,L)
#else
#define __OS_TaskTimerWork4(L)
#endif
//...........................................................
#if OS_TASKS > 5
#define __OS_TaskTimerWork5(L)    __OS_TaskTimerWork(5,L)
#else
#define __OS_TaskTimerWork5(L)
#endif
//...........................................................
#if OS_TASKS > 6
#define __OS_TaskTimerWork6(L)    __OS_TaskTimerWork(6,L)
#else
#define __OS_TaskTimerWork6(L)
#endif
//...........................................................
#if OS_TASKS > 7
#define __OS_TaskTimerWork7(L)    __OS_TaskTimerWork(7,L)
#else
#define __OS_TaskTimerWork7(L)
#endif
//...........................................................
#if OS_TASKS > 8
#define __OS_TaskTimerWork8(L)    __OS_TaskTimerWork(8,L)
#else
#define __OS_TaskTimerWork8(L)
#endif
//...........................................................
#if OS_TASKS > 9
#define __OS_TaskTimerWork9(L)    __OS_TaskTimerWork(9,L)
#else
#define __OS_TaskTimerWork9(L)
#endif
//...........................................................
#if OS_TASKS > 10
#define __OS_TaskTimerWork10(L)    __OS_TaskTimerWork(10,L)
#else
#define __OS_TaskTimerWork10(L)
#endif
//...........................................................
#if OS_TASKS > 11
#define __OS_TaskTimerWork11(L)    __OS_TaskTimerWork(11,L)
#else
#define __OS_TaskTimerWork11(L)
#endif
//...........................................................
#if OS_TASKS > 12
#define __OS_TaskTimerWork12(L)    __OS_TaskTimerWork(12,L)
#else
#define __OS_TaskTimerWork12(L)
#endif
//...........................................................
#if OS_TASKS > 13
#define __OS_TaskTimerWork13(L)    __OS_TaskTimerWork(13,L)
#else
#define __OS_TaskTimerWork13(L)
#endif
//...........................................................
#if OS_TASKS > 14
#define __OS_TaskTimerWork14(L)    __OS_TaskTimerWork(14,L)
#else
#define __OS_TaskTimerWork14(L)
#endif
//...........................................................
#if OS_TASKS > 15
#define __OS_TaskTimerWork15(L)    __OS_TaskTimerWork(15,L)
#else
#define __OS_TaskTimerWork15(L)
#endif
//...........................................................
#if OS_TASKS > 16
#define __OS_TaskTimerWork16(L)    __OS_TaskTimerWork(16,L)
#else
#define __OS_TaskTimerWork16(L)
#endif
//...........................................................
#if OS_TASKS > 17
#define __OS_TaskTimerWork17(L)    __OS_TaskTimerWork(17,L)
#else
#define __OS_TaskTimerWork17(L)
#endif
//...........................................................
#if OS_TASKS > 18
#define __OS_TaskTimerWork18(L)    __OS_TaskTimerWork(18,L)
#else
#define __OS_TaskTimerWork18(L)
#endif
//...........................................................
#if OS_TASKS > 19
#define __OS_TaskTimerWork19(L)    __OS_TaskTimerWork(19,L)
#else
#define __OS_TaskTimerWork19(L)
#endif
//...........................................................
#if OS_TASKS > 20
#define __OS_TaskTimerWork20(L)    __OS_TaskTimerWork(20,L)
#else
#define __OS_TaskTimerWork20(L)
#endif
//...........................................................
#if OS_TASKS > 21
#define __OS_TaskTimerWork21(L)    __OS_TaskTimerWork(21,L)
#else
#define __OS_TaskTimerWork21(L)
#endif
//...........................................................
#if OS_TASKS > 22
#define __OS_TaskTimerWork22(L)    __OS_TaskTimerWork(22,L)
#else
#define __OS_TaskTimerWork22(L)
#endif
//...........................................................
#if OS_TASKS > 23
#define __OS_TaskTimerWork23(L)    __OS_TaskTimerWork(23,L)
#else
#define __OS_TaskTimerWork23(L)
#endif
//...........................................................
#if OS_TASKS > 24
#define __OS_TaskTimerWork24(L)    __OS_TaskTimerWork(24,L)
#else
#define __OS_TaskTimerWork24(L)
#endif
//...........................................................
#if OS_TASKS > 25
#define __OS_TaskTimerWork25(L)    __OS_TaskTimerWork(25,L)
#else
#define __OS_TaskTimerWork25(L)
#endif
//...........................................................
#if OS_TASKS > 26
#define __OS_TaskTimerWork26(L)    __OS_TaskTimerWork(26,L)
#else
#define __OS_TaskTimerWork26(L)
#endif
//...........................................................
#if OS_TASKS > 27
#define __OS_TaskTimerWork27(L)    __OS_TaskTimerWork(27,L)
#else
#define __OS_TaskTimerWork27(L)
#endif
//...........................................................
#if OS_TASKS > 28
#define __OS_TaskTimerWork28(L)    __OS_TaskTimerWork(28,L)
#else
#define __OS_TaskTimerWork28(L)
#endif
//...........................................................
#if OS_TASKS > 29
#define __OS_TaskTimerWork29(L)    __OS_TaskTimerWork(29,L)
#else
#define __OS_TaskTimerWork29(L)
#endif
//...........................................................
#if OS_TASKS > 30
#define __OS_TaskTimerWork30(L)    __OS_TaskTimerWork(30,L)
#else
#define __OS_TaskTimerWork30(L)
#endif
//...........................................................
#if OS_TASKS > 31
#define __OS_TaskTimerWork31(L)    __OS_TaskTimerWork(31,L)
#else
#define __OS_TaskTimerWork31(L)
#endif
//...........................................................
#if OS_TASKS > 32
#define __OS_TaskTimerWork32(L)    __OS_TaskTimerWork(32,L)
#else
#define __OS_TaskTimerWork32(L)
#endif
//...........................................................
#if OS_TASKS > 33
#define __OS_TaskTimerWork33(L)    __OS_TaskTimerWork(33,L)
#else
#define __OS_TaskTimerWork33(L)
#endif
//...........................................................
#if OS_TASKS > 34
#define __OS_TaskTimerWork34(L)    __OS_TaskTimerWork(34,L)
#else
#define __OS_TaskTimerWork34(L)
#endif
//...........................................................
#if OS_TASKS > 35
#define __OS_TaskTimerWork35(L)    __OS_TaskTimerWork(35,L)
#else
#define __OS_TaskTimerWork35(L)
#endif
//...........................................................
#if OS_TASKS > 36
#define __OS_TaskTimerWork36(L)    __OS_TaskTimerWork(36,L)
#else
#define __OS_TaskTimerWork36(L)
#endif
//...........................................................
#if OS_TASKS > 37
#define __OS_TaskTimerWork37(L)    __OS_TaskTimerWork(37,L)
#else
#define __OS_TaskTimerWork37(L)
#endif
//...........................................................
#if OS_TASKS > 38
#define __OS_TaskTimerWork38(L)    __OS_TaskTimerWork(38,L)
#else
#define __OS_TaskTimerWork38(L)
#endif
//...........................................................
#if OS_TASKS > 39
#define __OS_TaskTimerWork39(L)    __OS_TaskTimerWork(39,L)
#else
#define __OS_TaskTimerWork39(L)
#endif
//...........................................................
#if OS_TASKS > 40
#define __OS_TaskTimerWork40(L)    __OS_TaskTimerWork(40,L)
#else
#define __OS_TaskTimerWork40(L)
#endif
//...........................................................
#if OS_TASKS > 41
#define __OS_TaskTimerWork41(L)    __OS_TaskTimerWork(41,L)
#else
#define __OS_TaskTimerWork41(L)
#endif
//...........................................................
#if OS_TASKS > 42
#define __OS_TaskTimerWork42(L)    __OS_TaskTimerWork(42,L)
#else
#define __OS_TaskTimerWork42(L)
#endif
//...........................................................
#if OS_TASKS > 43
#define __OS_TaskTimerWork43(L)    __OS_TaskTimerWork(43,L)
#else
#define __OS_TaskTimerWork43(L)
#endif
//...........................................................
#if OS_TASKS > 44
#define __OS_TaskTimerWork44(L)    __OS_TaskTimerWork(44,L)
#else
#define __OS_TaskTimerWork44(L)
#endif
//...........................................................
#if OS_TASKS > 45
#define __OS_TaskTimerWork45(L)    __OS_TaskTimerWork(45,L)
#else
#define __OS_TaskTimerWork45(L)
#endif
//...........................................................
#if OS_TASKS > 46
#define __OS_TaskTimerWork46(L)    __OS_TaskTimerWork(46,L)
#else
#define __OS_TaskTimerWork46(L)
#endif
//...........................................................
#if OS_TASKS > 47
#define __OS_TaskTimerWork47(L)    __OS_TaskTimerWork(47,L)
#else
#define __OS_TaskTimerWork47(L)
#endif
//...........................................................
#if OS_TASKS > 48
#define __OS_TaskTimerWork48(L)    __OS_TaskTimerWork(48,L)
#else
#define __OS_TaskTimerWork48(L)
#endif
//...........................................................
#if OS_TASKS > 49
#define __OS_TaskTimerWork49(L)    __OS_TaskTimerWork(49,L)
#else
#define __OS_TaskTimerWork49(L)
#endif
//...........................................................
#if OS_TASKS > 50
#define __OS_TaskTimerWork50(L)    __OS_TaskTimerWork(50,L)
#else
#define __OS_TaskTimerWork50(L)
#endif
//...........................................................
#if OS_TASKS > 51
#define __OS_TaskTimerWork51(L)    __OS_TaskTimerWork(51,L)
#else
#define __OS_TaskTimerWork51(L)
#endif
//...........................................................
#if OS_TASKS > 52
#define __OS_TaskTimerWork52(L)    __OS_TaskTimerWork(52,L)
#else
#define __OS_TaskTimerWork52(L)
#endif
//...........................................................
#if OS_TASKS > 53
#define __OS_TaskTimerWork53(L)    __OS_TaskTimerWork(53,L)
#else
#define __OS_TaskTimerWork53(L)
#endif
//...........................................................
#if OS_TASKS > 54
#define __OS_TaskTimerWork54(L)    __OS_TaskTimerWork(54,L)
#else
#define __OS_TaskTimerWork54(L)
#endif
//...........................................................
#if OS_TASKS > 55
#define __OS_TaskTimerWork55(L)    __OS_TaskTimerWork(55,L)
#else
#define __OS_TaskTimerWork55(L)
#endif
//...........................................................
#if OS_TASKS > 56
#define __OS_TaskTimerWork56(L)    __OS_TaskTimerWork(56,L)
#else
#define __OS_TaskTimerWork56(L)
#endif
//...........................................................
#if OS_TASKS > 57
#define __OS_TaskTimerWork57(L)    __OS_TaskTimerWork(57,L)
#else
#define __OS_TaskTimerWork57(L)
#endif
//...........................................................
#if OS_TASKS > 58
#define __OS_TaskTimerWork58(L)    __OS_TaskTimerWork(58,L)
#else
#define __OS_TaskTimerWork58(L)
#endif
//...........................................................
#if OS_TASKS > 59
#define __OS_TaskTimerWork59(L)    __OS_TaskTimerWork(59,L)
#else
#define __OS_TaskTimerWork59(L)
#endif
//...........................................................
#if OS_TASKS > 60
#define __OS_TaskTimerWork60(L)    __OS_TaskTimerWork(60,L)
#else
#define __OS_TaskTimerWork60(L)
#endif
//...........................................................
#if OS_TASKS > 61
#define __OS_TaskTimerWork61(L)    __OS_TaskTimerWork(61,L)
#else
#define __OS_TaskTimerWork61(L)
#endif
//...........................................................
#if OS_TASKS > 62
#define __OS_TaskTimerWork62(L)    __OS_TaskTimerWork(62,L)
#else
#define __OS_TaskTimerWork62(L)
#endif
//...........................................................
#if OS_TASKS > 63
#define __OS_TaskTimerWork63(L)    __OS_TaskTimerWork(63,L)
#else
#define __OS_TaskTimerWork63(L)
#endif
//...........................................................

/**/

#ifndef ASM_OST_TCB_SIZE_CONST
#define ASM_OST_TCB_SIZE_CONST
#endif

#ifndef ASM_SET_BANK
#define ASM_SET_BANK
#endif

#if defined(OS_ENABLE_TTIMERS)
#define __OS_TaskTimersWork()       \
{                                   \
    ASM_OST_TCB_SIZE_CONST;         \
    ASM_SET_BANK;                   \
    __OS_TaskTimerWork0(L);         \
    __OS_TaskTimerWork1(L);         \
    __OS_TaskTimerWork2(L);         \
    __OS_TaskTimerWork3(L);         \
    __OS_TaskTimerWork4(L);         \
    __OS_TaskTimerWork5(L);         \
    __OS_TaskTimerWork6(L);         \
    __OS_TaskTimerWork7(L);         \
    __OS_TaskTimerWork8(L);         \
    __OS_TaskTimerWork9(L);         \
    __OS_TaskTimerWork10(L);        \
    __OS_TaskTimerWork11(L);        \
    __OS_TaskTimerWork12(L);        \
    __OS_TaskTimerWork13(L);        \
    __OS_TaskTimerWork14(L);        \
    __OS_TaskTimerWork15(L);        \
    __OS_TaskTimerWork16(L);        \
    __OS_TaskTimerWork17(L);        \
    __OS_TaskTimerWork18(L);        \
    __OS_TaskTimerWork19(L);        \
    __OS_TaskTimerWork20(L);        \
    __OS_TaskTimerWork21(L);        \
    __OS_TaskTimerWork22(L);        \
    __OS_TaskTimerWork23(L);        \
    __OS_TaskTimerWork24(L);        \
    __OS_TaskTimerWork25(L);        \
    __OS_TaskTimerWork26(L);        \
    __OS_TaskTimerWork27(L);        \
    __OS_TaskTimerWork28(L);        \
    __OS_TaskTimerWork29(L);        \
    __OS_TaskTimerWork30(L);        \
    __OS_TaskTimerWork31(L);        \
    __OS_TaskTimerWork32(L);        \
    __OS_TaskTimerWork33(L);        \
    __OS_TaskTimerWork34(L);        \
    __OS_TaskTimerWork35(L);        \
    __OS_TaskTimerWork36(L);        \
    __OS_TaskTimerWork37(L);        \
    __OS_TaskTimerWork38(L);        \
    __OS_TaskTimerWork39(L);        \
    __OS_TaskTimerWork40(L);        \
    __OS_TaskTimerWork41(L);        \
    __OS_TaskTimerWork42(L);        \
    __OS_TaskTimerWork43(L);        \
    __OS_TaskTimerWork44(L);        \
    __OS_TaskTimerWork45(L);        \
    __OS_TaskTimerWork46(L);        \
    __OS_TaskTimerWork47(L);        \
    __OS_TaskTimerWork48(L);        \
    __OS_TaskTimerWork49(L);        \
    __OS_TaskTimerWork50(L);        \
    __OS_TaskTimerWork51(L);        \
    __OS_TaskTimerWork52(L);        \
    __OS_TaskTimerWork53(L);        \
    __OS_TaskTimerWork54(L);        \
    __OS_TaskTimerWork55(L);        \
    __OS_TaskTimerWork56(L);        \
    __OS_TaskTimerWork57(L);        \
    __OS_TaskTimerWork58(L);        \
    __OS_TaskTimerWork59(L);        \
    __OS_TaskTimerWork60(L);        \
    __OS_TaskTimerWork61(L);        \
    __OS_TaskTimerWork62(L);        \
    __OS_TaskTimerWork63(L);        \
}
#else
    #define __OS_TaskTimersWork()
#endif





/************************************************************************/
/*                                                                      */
/************************************************************************/

//...........................................................
#if OS_STIMERS > 0
#define __OS_STimerWork0(L)    __OS_STimerWork(0,L)
#else
#define __OS_STimerWork0(L)
#endif
//...........................................................
#if OS_STIMERS > 1
#define __OS_STimerWork1(L)    __OS_STimerWork(1,L)
#else
#define __OS_STimerWork1(L)
#endif
//...........................................................
#if OS_STIMERS > 2
#define __OS_STimerWork2(L)    __OS_STimerWork(2,L)
#else
#define __OS_STimerWork2(L)
#endif
//...........................................................
#if OS_STIMERS > 3
#define __OS_STimerWork3(L)    __OS_STimerWork(3,L)
#else
#define __OS_STimerWork3(L)
#endif
//...........................................................
#if OS_STIMERS > 4
#define __OS_STimerWork4(L)    __OS_STimerWork(4,L)
#else
#define __OS_STimerWork4(L)
#endif
//...........................................................
#if OS_STIMERS > 5
#define __OS_STimerWork5(L)    __OS_STimerWork(5,L)
#else
#define __OS_STimerWork5(L)
#endif
//...........................................................
#if OS_STIMERS > 6
#define __OS_STimerWork6(L)    __OS_STimerWork(6,L)
#else
#define __OS_STimerWork6(L)
#endif
//...........................................................
#if OS_STIMERS > 7
#define __OS_STimerWork7(L)    __OS_STimerWork(7,L)
#else
#define __OS_STimerWork7(L)
#endif
//...........................................................
#if OS_STIMERS > 8
#define __OS_STimerWork8(L)    __OS_STimerWork(8,L)
#else
#define __OS_STimerWork8(L)
#endif
//...........................................................
#if OS_STIMERS > 9
#define __OS_STimerWork9(L)    __OS_STimerWork(9,L)
#else
#define __OS_STimerWork9(L)
#endif
//...........................................................
#if OS_STIMERS > 10
#define __OS_STimerWork10(L)    __OS_STimerWork(10,L)
#else
#define __OS_STimerWork10(L)
#endif
//...........................................................
#if OS_STIMERS > 11
#define __OS_STimerWork11(L)    __OS_STimerWork(11,L)
#else
#define __OS_STimerWork11(L)
#endif
//...........................................................
#if OS_STIMERS > 12
#define __OS_STimerWork12(L)    __OS_STimerWork(12,L)
#else
#define __OS_STimerWork12(L)
#endif
//...........................................................
#if OS_STIMERS > 13
#define __OS_STimerWork13(L)    __OS_STimerWork(13,L)
#else
#define __OS_STimerWork13(L)
#endif
//...........................................................
#if OS_STIMERS > 14
#define __OS_STimerWork14(L)    __OS_STimerWork(14,L)
#else
#define __OS_STimerWork14(L)
#endif
//...........................................................
#if OS_STIMERS > 15
#define __OS_STimerWork15(L)    __OS_STimerWork(15,L)
#else
#define __OS_STimerWork15(L)
#endif
//...........................................................
#if OS_STIMERS > 16
#define __OS_STimerWork16(L)    __OS_STimerWork(16,L)
#else
#define __OS_STimerWork16(L)
#endif
//...........................................................
#if OS_STIMERS > 17
#define __OS_STimerWork17(L)    __OS_STimerWork(17,L)
#else
#define __OS_STimerWork17(L)
#endif
//...........................................................
#if OS_STIMERS > 18
#define __OS_STimerWork18(L)    __OS_STimerWork(18,L)
#else
#define __OS_STimerWork18(L)
#endif
//...........................................................
#if OS_STIMERS > 19
#define __OS_STimerWork19(L)    __OS_STimerWork(19,L)
#else
#define __OS_STimerWork19(L)
#endif
//...........................................................
#if OS_STIMERS > 20
#define __OS_STimerWork20(L)    __OS_STimerWork(20,L)
#else
#define __OS_STimerWork20(L)
#endif
//...........................................................
#if OS_STIMERS > 21
#define __OS_STimerWork21(L)    __OS_STimerWork(21,L)
#else
#define __OS_STimerWork21(L)
#endif
//...........................................................
#if OS_STIMERS > 22
#define __OS_STimerWork22(L)    __OS_STimerWork(22,L)
#else
#define __OS_STimerWork22(L)
#endif
//...........................................................
#if OS_STIMERS > 23
#define __OS_STimerWork23(L)    __OS_STimerWork(23,L)
#else
#define __OS_STimerWork23(L)
#endif
//...........................................................
#if OS_STIMERS > 24
#define __OS_STimerWork24(L)    __OS_STimerWork(24,L)
#else
#define __OS_STimerWork24(L)
#endif
//...........................................................
#if OS_STIMERS > 25
#define __OS_STimerWork25(L)    __OS_STimerWork(25,L)
#else
#define __OS_STimerWork25(L)
#endif
//...........................................................
#if OS_STIMERS > 26
#define __OS_STimerWork26(L)    __OS_STimerWork(26,L)
#else
#define __OS_STimerWork26(L)
#endif
//...........................................................
#if OS_STIMERS > 27
#define __OS_STimerWork27(L)    __OS_STimerWork(27,L)
#else
#define __OS_STimerWork27(L)
#endif
//...........................................................
#if OS_STIMERS > 28
#define __OS_STimerWork28(L)    __OS_STimerWork(28,L)
#else
#define __OS_STimerWork28(L)
#endif
//...........................................................
#if OS_STIMERS > 29
#define __OS_STimerWork29(L)    __OS_STimerWork(29,L)
#else
#define __OS_STimerWork29(L)
#endif
//...........................................................
#if OS_STIMERS > 30
#define __OS_STimerWork30(L)    __OS_STimerWork(30,L)
#else
#define __OS_STimerWork30(L)
#endif
//...........................................................
#if OS_STIMERS > 31
#define __OS_STimerWork31(L)    __OS_STimerWork(31,L)
#else
#define __OS_STimerWork31(L)
#endif
//...........................................................
#if OS_STIMERS > 32
#define __OS_STimerWork32(L)    __OS_STimerWork(32,L)
#else
#define __OS_STimerWork32(L)
#endif
//...........................................................
#if OS_STIMERS > 33
#define __OS_STimerWork33(L)    __OS_STimerWork(33,L)
#else
#define __OS_STimerWork33(L)
#endif
//...........................................................
#if OS_STIMERS > 34
#define __OS_STimerWork34(L)    __OS_STimerWork(34,L)
#else
#define __OS_STimerWork34(L)
#endif
//...........................................................
#if OS_STIMERS > 35
#define __OS_STimerWork35(L)    __OS_STimerWork(35,L)
#else
#define __OS_STimerWork35(L)
#endif
//...........................................................
#if OS_STIMERS > 36
#define __OS_STimerWork36(L)    __OS_STimerWork(36,L)
#else
#define __OS_STimerWork36(L)
#endif
//...........................................................
#if OS_STIMERS > 37
#define __OS_STimerWork37(L)    __OS_STimerWork(37,L)
#else
#define __OS_STimerWork37(L)
#endif
//...........................................................
#if OS_STIMERS > 38
#define __OS_STimerWork38(L)    __OS_STimerWork(38,L)
#else
#define __OS_STimerWork38(L)
#endif
//...........................................................
#if OS_STIMERS > 39
#define __OS_STimerWork39(L)    __OS_STimerWork(39,L)
#else
#define __OS_STimerWork39(L)
#endif
//...........................................................
#if OS_STIMERS > 40
#define __OS_STimerWork40(L)    __OS_STimerWork(40,L)
#else
#define __OS_STimerWork40(L)
#endif
//...........................................................
#if OS_STIMERS > 41
#define __OS_STimerWork41(L)    __OS_STimerWork(41,L)
#else
#define __OS_STimerWork41(L)
#endif
//...........................................................
#if OS_STIMERS > 42
#define __OS_STimerWork42(L)    __OS_STimerWork(42,L)
#else
#define __OS_STimerWork42(L)
#endif
//...........................................................
#if OS_STIMERS > 43
#define __OS_STimerWork43(L)    __OS_STimerWork(43,L)
#else
#define __OS_STimerWork43(L)
#endif
//...........................................................
#if OS_STIMERS > 44
#define __OS_STimerWork44(L)    __OS_STimerWork(44,L)
#else
#define __OS_STimerWork44(L)
#endif
//...........................................................
#if OS_STIMERS > 45
#define __OS_STimerWork45(L)    __OS_STimerWork(45,L)
#else
#define __OS_STimerWork45(L)
#endif
//...........................................................
#if OS_STIMERS > 46
#define __OS_STimerWork46(L)    __OS_STimerWork(46,L)
#else
#define __OS_STimerWork46(L)
#endif
//...........................................................
#if OS_STIMERS > 47
#define __OS_STimerWork47(L)    __OS_STimerWork(47,L)
#else
#define __OS_STimerWork47(L)
#endif
//...........................................................
#if OS_STIMERS > 48
#define __OS_STimerWork48(L)    __OS_STimerWork(48,L)
#else
#define __OS_STimerWork48(L)
#endif
//...........................................................
#if OS_STIMERS > 49
#define __OS_STimerWork49(L)    __OS_STimerWork(49,L)
#else
#define __OS_STimerWork49(L)
#endif
//...........................................................
#if OS_STIMERS > 50
#define __OS_STimerWork50(L)    __OS_STimerWork(50,L)
#else
#define __OS_STimerWork50(L)
#endif
//...........................................................
#if OS_STIMERS > 51
#define __OS_STimerWork51(L)    __OS_STimerWork(51,L)
#else
#define __OS_STimerWork51(L)
#endif
//...........................................................
#if OS_STIMERS > 52
#define __OS_STimerWork52(L)    __OS_STimerWork(52,L)
#else
#define __OS_STimerWork52(L)
#endif
//...........................................................
#if OS_STIMERS > 53
#define __OS_STimerWork53(L)    __OS_STimerWork(53,L)
#else
#define __OS_STimerWork53(L)
#endif
//...........................................................
#if OS_STIMERS > 54
#define __OS_STimerWork54(L)    __OS_STimerWork(54,L)
#else
#define __OS_STimerWork54(L)
#endif
//...........................................................
#if OS_STIMERS > 55
#define __OS_STimerWork55(L)    __OS_STimerWork(55,L)
#else
#define __OS_STimerWork55(L)
#endif
//...........................................................
#if OS_STIMERS > 56
#define __OS_STimerWork56(L)    __OS_STimerWork(56,L)
#else
#define __OS_STimerWork56(L)
#endif
//...........................................................
#if OS_STIMERS > 57
#define __OS_STimerWork57(L)    __OS_STimerWork(57,L)
#else
#define __OS_STimerWork57(L)
#endif
//...........................................................
#if OS_STIMERS > 58
#define __OS_STimerWork58(L)    __OS_STimerWork(58,L)
#else
#define __OS_STimerWork58(L)
#endif
//...........................................................
#if OS_STIMERS > 59
#define __OS_STimerWork59(L)    __OS_STimerWork(59,L)
#else
#define __OS_STimerWork59(L)
#endif
//...........................................................
#if OS_STIMERS > 60
#define __OS_STimerWork60(L)    __OS_STimerWork(60,L)
#else
#define __OS_STimerWork60(L)
#endif
//...........................................................
#if OS_STIMERS > 61
#define __OS_STimerWork61(L)    __OS_STimerWork(61,L)
#else
#define __OS_STimerWork61(L)
#endif
//...........................................................
#if OS_STIMERS > 62
#define __OS_STimerWork62(L)    __OS_STimerWork(62,L)
#else
#define __OS_STimerWork62(L)
#endif
//...........................................................
#if OS_STIMERS > 63
#define __OS_STimerWork63(L)    __OS_STimerWork(63,L)
#else
#define __OS_STimerWork63(L)
#endif
//...........................................................


#define __OS_STimersWork()          \
    __OS_STimerWork0(L);            \
    __OS_STimerWork1(L);            \
    __OS_STimerWork2(L);            \
    __OS_STimerWork3(L);            \
    __OS_STimerWork4(L);            \
    __OS_STimerWork5(L);            \
    __OS_STimerWork6(L);            \
    __OS_STimerWork7(L);            \
    __OS_STimerWork8(L);            \
    __OS_STimerWork9(L);            \
    __OS_STimerWork10(L);           \
    __OS_STimerWork11(L);           \
    __OS_STimerWork12(L);           \
    __OS_STimerWork13(L);           \
    __OS_STimerWork14(L);           \
    __OS_STimerWork15(L);           \
    __OS_STimerWork16(L);           \
    __OS_STimerWork17(L);           \
    __OS_STimerWork18(L);           \
    __OS_STimerWork19(L);           \
    __OS_STimerWork20(L);           \
    __OS_STimerWork21(L);           \
    __OS_STimerWork22(L);           \
    __OS_STimerWork23(L);           \
    __OS_STimerWork24(L);           \
    __OS_STimerWork25(L);           \
    __OS_STimerWork26(L);           \
    __OS_STimerWork27(L);           \
    __OS_STimerWork28(L);           \
    __OS_STimerWork29(L);           \
    __OS_STimerWork30(L);           \
    __OS_STimerWork31(L);           \
    __OS_STimerWork32(L);           \
    __OS_STimerWork33(L);           \
    __OS_STimerWork34(L);           \
    __OS_STimerWork35(L);           \
    __OS_STimerWork36(L);           \
    __OS_STimerWork37(L);           \
    __OS_STimerWork38(L);           \
    __OS_STimerWork39(L);           \
    __OS_STimerWork40(L);           \
    __OS_STimerWork41(L);           \
    __OS_STimerWork42(L);           \
    __OS_STimerWork43(L);           \
    __OS_STimerWork44(L);           \
    __OS_STimerWork45(L);           \
    __OS_STimerWork46(L);           \
    __OS_STimerWork47(L);           \
    __OS_STimerWork48(L);           \
    __OS_STimerWork49(L);           \
    __OS_STimerWork50(L);           \
    __OS_STimerWork51(L);           \
    __OS_STimerWork52(L);           \
    __OS_STimerWork53(L);           \
    __OS_STimerWork54(L);           \
    __OS_STimerWork55(L);           \
    __OS_STimerWork56(L);           \
    __OS_STimerWork57(L);           \
    __OS_STimerWork58(L);           \
    __OS_STimerWork59(L);           \
    __OS_STimerWork60(L);           \
    __OS_STimerWork61(L);           \
    __OS_STimerWork62(L);           \
    __OS_STimerWork63(L);           \









//______________________________________________________________________________
//******************************************************************************


#define OS_TimerInline()    __OS_TimerInline(os_inline)


#if defined(OS_SLOW_TIMERS) || OS_TIMERS24 > 0
#define _OS_IncOSTicks()    OS_Ticks++;
#else
#define _OS_IncOSTicks()
#endif





/************************************************************************************************
 *                                                                                              *
 *     S Y S T E M   T I M E R   W O R K   M A C R O                                            *
 *                                                                                              *
 ************************************************************************************************/

#define __OS_TimerInline(L)                                             \
{                                                                       \
    _OS_IncOSTicks();                                                   \
                                                                        \
    __OS_TaskTimersWork();                                              \
    __OS_Timer8Work0(L);                                                \
    __OS_Timer8Work1(L);                                                \
    __OS_Timer8Work2(L);                                                \
    __OS_Timer8Work3(L);                                                \
    __OS_Timer8Work4(L);                                                \
    __OS_Timer8Work5(L);                                                \
    __OS_Timer8Work6(L);                                                \
    __OS_Timer8Work7(L);                                                \
    __OS_Timer8Work8(L);                                                \
    __OS_Timer8Work9(L);                                                \
    __OS_Timer8Work10(L);                                               \
    __OS_Timer8Work11(L);                                               \
    __OS_Timer8Work12(L);                                               \
    __OS_Timer8Work13(L);                                               \
    __OS_Timer8Work14(L);                                               \
    __OS_Timer8Work15(L);                                               \
    __OS_Timer8Work16(L);                                               \
    __OS_Timer8Work17(L);                                               \
    __OS_Timer8Work18(L);                                               \
    __OS_Timer8Work19(L);                                               \
    __OS_Timer8Work20(L);                                               \
    __OS_Timer8Work21(L);                                               \
    __OS_Timer8Work22(L);                                               \
    __OS_Timer8Work23(L);                                               \
    __OS_Timer8Work24(L);                                               \
    __OS_Timer8Work25(L);                                               \
    __OS_Timer8Work26(L);                                               \
    __OS_Timer8Work27(L);                                               \
    __OS_Timer8Work28(L);                                               \
    __OS_Timer8Work29(L);                                               \
    __OS_Timer8Work30(L);                                               \
    __OS_Timer8Work31(L);                                               \
                                                                        \
    __OS_Timer16Work0(L);                                               \
    __OS_Timer16Work1(L);                                               \
    __OS_Timer16Work2(L);                                               \
    __OS_Timer16Work3(L);                                               \
    __OS_Timer16Work4(L);                                               \
    __OS_Timer16Work5(L);                                               \
    __OS_Timer16Work6(L);                                               \
    __OS_Timer16Work7(L);                                               \
    __OS_Timer16Work8(L);                                               \
    __OS_Timer16Work9(L);                                               \
    __OS_Timer16Work10(L);                                              \
    __OS_Timer16Work11(L);                                              \
    __OS_Timer16Work12(L);                                              \
    __OS_Timer16Work13(L);                                              \
    __OS_Timer16Work14(L);                                              \
    __OS_Timer16Work15(L);                                              \
    __OS_Timer16Work16(L);                                              \
    __OS_Timer16Work17(L);                                              \
    __OS_Timer16Work18(L);                                              \
    __OS_Timer16Work19(L);                                              \
    __OS_Timer16Work20(L);                                              \
    __OS_Timer16Work21(L);                                              \
    __OS_Timer16Work22(L);                                              \
    __OS_Timer16Work23(L);                                              \
    __OS_Timer16Work24(L);                                              \
    __OS_Timer16Work25(L);                                              \
    __OS_Timer16Work26(L);                                              \
    __OS_Timer16Work27(L);                                              \
    __OS_Timer16Work28(L);                                              \
    __OS_Timer16Work29(L);                                              \
    __OS_Timer16Work30(L);                                              \
    __OS_Timer16Work31(L);                                              \
                                                                        \
    __OS_Timer32Work0(L);                                               \
    __OS_Timer32Work1(L);                                               \
    __OS_Timer32Work2(L);                                               \
    __OS_Timer32Work3(L);                                               \
    __OS_Timer32Work4(L);                                               \
    __OS_Timer32Work5(L);                                               \
    __OS_Timer32Work6(L);                                               \
    __OS_Timer32Work7(L);                                               \
    __OS_Timer32Work8(L);                                               \
    __OS_Timer32Work9(L);                                               \
    __OS_Timer32Work10(L);                                              \
    __OS_Timer32Work11(L);                                              \
    __OS_Timer32Work12(L);                                              \
    __OS_Timer32Work13(L);                                              \
    __OS_Timer32Work14(L);                                              \
    __OS_Timer32Work15(L);                                              \
    __OS_Timer32Work16(L);                                              \
    __OS_Timer32Work17(L);                                              \
    __OS_Timer32Work18(L);                                              \
    __OS_Timer32Work19(L);                                              \
    __OS_Timer32Work20(L);                                              \
    __OS_Timer32Work21(L);                                              \
    __OS_Timer32Work22(L);                                              \
    __OS_Timer32Work23(L);                                              \
    __OS_Timer32Work24(L);                                              \
    __OS_Timer32Work25(L);                                              \
    __OS_Timer32Work26(L);                                              \
    __OS_Timer32Work27(L);                                              \
    __OS_Timer32Work28(L);                                              \
    __OS_Timer32Work29(L);                                              \
    __OS_Timer32Work30(L);                                              \
    __OS_Timer32Work31(L);                                              \
                                                                        \
    __OS_CheckInc24()                                                   \
    {                                                                   \
        __OS_Timer24Work0(L);                                           \
        __OS_Timer24Work1(L);                                           \
        __OS_Timer24Work2(L);                                           \
        __OS_Timer24Work3(L);                                           \
        __OS_Timer24Work4(L);                                           \
        __OS_Timer24Work5(L);                                           \
        __OS_Timer24Work6(L);                                           \
        __OS_Timer24Work7(L);                                           \
        __OS_Timer24Work8(L);                                           \
        __OS_Timer24Work9(L);                                           \
        __OS_Timer24Work10(L);                                          \
        __OS_Timer24Work11(L);                                          \
        __OS_Timer24Work12(L);                                          \
        __OS_Timer24Work13(L);                                          \
        __OS_Timer24Work14(L);                                          \
        __OS_Timer24Work15(L);                                          \
        __OS_Timer24Work16(L);                                          \
        __OS_Timer24Work17(L);                                          \
        __OS_Timer24Work18(L);                                          \
        __OS_Timer24Work19(L);                                          \
        __OS_Timer24Work20(L);                                          \
        __OS_Timer24Work21(L);                                          \
        __OS_Timer24Work22(L);                                          \
        __OS_Timer24Work23(L);                                          \
        __OS_Timer24Work24(L);                                          \
        __OS_Timer24Work25(L);                                          \
        __OS_Timer24Work26(L);                                          \
        __OS_Timer24Work27(L);                                          \
        __OS_Timer24Work28(L);                                          \
        __OS_Timer24Work29(L);                                          \
        __OS_Timer24Work30(L);                                          \
        __OS_Timer24Work31(L);                                          \
    }                                                                   \
                                                                        \
    __OS_STimersWork();                                                 \
    __OS_DTimersWork();                                                 \
}







//------------------------------------------------------------------------------
#endif      // _OS_TIMER_H_
//------------------------------------------------------------------------------



















