/*
 ************************************************************************************************
 *                                                                                              *
 *  OSA cooperative RTOS for Microchip PIC-controllers: PIC10/12/16/18/24/dsPIC                 *
 *                                                                                              *
 *  URL:        http://wiki.pic24.ru/doku.php/en/osa/ref/intro                                  *
 *              http://picosa.narod.ru                                                          *
 *                                                                                              *
 *----------------------------------------------------------------------------------------------*
 *                                                                                              *
 *  File:       osa_stimer_old.h                                                                *
 *                                                                                              *
 *  Compilers:  HT-PICC STD                                                                     *
 *              HT-PICC18 STD                                                                   *
 *              Microchip C18                                                                   *
 *              Microchip C30                                                                   *
 *                                                                                              *
 *  Programmer: Timofeev Victor                                                                 *
 *              osa@pic24.ru, testerplus@mail.ru                                                *
 *                                                                                              *
 *  Definition: Services with old static services                                               *
 *                                                                                              *
 *  History:    21.01.2009                                                                      *
 *                                                                                              *
 *  (not recommended to use. use STimers instead (see osa_stimers.h)                            *
 *                                                                                              *
 *                                                                                              *
 ************************************************************************************************
 */



/************************************************************************************************
 *                                                                                              *
 *                           O L D   S T Y L E   S T A T I C   T I M E R S                      *
 *                                                                                              *
 ************************************************************************************************/


//------------------------------------------------------------------------------
// Stop timer

#define _OS_TMR_POS(timer_id)   ((timer_id) >> _OST_INT_SHIFT)
#define _OS_TMR_MASK(timer_id)  (1 << ((timer_id) & _OST_INT_MASK))

#define OS_Oldtimer_Stop(timer_id)  OS_Timeouts[_OS_TMR_POS(timer_id)] &= ~_OS_TMR_MASK(timer_id)

//------------------------------------------------------------------------------
// Run timer (internal system macro)

#define _OS_RunTimer(timer_id)  OS_Timeouts[_OS_TMR_POS(timer_id)] |=  _OS_TMR_MASK(timer_id)

//------------------------------------------------------------------------------
// Check for overflow

#define OS_Oldtimer_Check(timer_id) !(OS_Timeouts[_OS_TMR_POS(timer_id)] & _OS_TMR_MASK(timer_id))

//------------------------------------------------------------------------------
// Check for timer is running

#define OS_IsTimerRun(timer_id) (OS_Timeouts[_OS_TMR_POS(timer_id)] & _OS_TMR_MASK(timer_id))


//------------------------------------------------------------------------------
// Run 8-bit timer

#define OS_Oldtimer_Run8(timer_id, time)                                    \
    {                                                                       \
        OS_Oldtimer_Stop(timer_id);                                         \
        OS_Timers8 [timer_id] = -(time);                                    \
        _OS_RunTimer(timer_id);                                             \
    }


//------------------------------------------------------------------------------
// Run 16-bit timer

#define OS_Oldtimer_Run16(timer_id, time)                                   \
    {                                                                       \
        OS_Oldtimer_Stop(timer_id);                                         \
        OS_Timers16[(timer_id) - _OS_TIMER16_POS] = -(time);                \
        _OS_RunTimer(timer_id);                                             \
    }

//------------------------------------------------------------------------------
// Run 24-bit timer

#define OS_Oldtimer_Run24(timer_id, time)                                   \
    {                                                                       \
        OS_Oldtimer_Stop(timer_id);                                         \
        OS_Timers24[(timer_id) - _OS_TIMER24_POS] = - (((time) + 128) >> 8);\
        _OS_RunTimer(timer_id);                                             \
    }

//------------------------------------------------------------------------------
// Run 24-bit timer withowt recounting prescaler (not recomended to use)

#define OS_Oldtimer_Run24prs(timer_id, time)                                \
    {                                                                       \
        OS_Oldtimer_Stop(timer_id);                                         \
        OS_Timers24[(timer_id) - _OS_TIMER24_POS] = -(time);                \
        _OS_RunTimer(timer_id);                                             \
    }

//------------------------------------------------------------------------------
// Run 32-bit timer

#define OS_Oldtimer_Run32(timer_id, time)                                   \
    {                                                                       \
        OS_Oldtimer_Stop(timer_id);                                         \
        OS_Timers32[(timer_id) - _OS_TIMER32_POS] = -(time);                \
        _OS_RunTimer(timer_id);                                             \
    }
//------------------------------------------------------------------------------
// Wait for timer overflowed

#define OS_Oldtimer_Wait(timer_id)                                          \
    {                                                                       \
        _OS_WAIT_EVENT(OS_Oldtimer_Check(timer_id));                        \
    }

//------------------------------------------------------------------------------
// Delay current task using old style static timer
#define OS_DelayTimer8(timer_id, delay)                                     \
    {                                                                       \
        OS_Oldtimer_Run8(timer_id, delay);                                  \
        OS_Oldtimer_Wait(timer_id);                                         \
    }

//------------------------------------------------------------------------------
#define OS_DelayTimer16(timer_id, delay)                                    \
    {                                                                       \
        OS_Oldtimer_Run16(timer_id, delay);                                 \
        OS_Oldtimer_Wait(timer_id);                                         \
    }

//------------------------------------------------------------------------------
#define OS_DelayTimer24(timer_id, delay)                                    \
    {                                                                       \
        OS_Oldtimer_Run24(timer_id, delay);                                 \
        OS_Oldtimer_Wait(timer_id);                                         \
    }

//------------------------------------------------------------------------------
#define OS_DelayTimer32(timer_id, delay)                                    \
    {                                                                       \
        OS_Oldtimer_Run32(timer_id, delay);                                 \
        OS_Oldtimer_Wait(timer_id);                                         \
    }


















